% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmForc_transform.R
\name{convert_byh}
\alias{convert_byh}
\title{Convert a list of time format Forecast objects to a h_ahead format Forecast
object.}
\usage{
convert_byh(forcs, index, h_aheads)
}
\arguments{
\item{forcs}{List of Forecast objects with the same number of observations.}

\item{index}{Numeric or logical value or vector.}

\item{h_aheads}{Value or vector of h_ahead values that is equal in length
to the index argument.}
}
\value{
Single Forecast object or list of Forecast objects in h_ahead format.
}
\description{
Given a list of forecasts with homogenous origin or future values, converts the
forecasts to h_ahead format based on the index passed to the index argument.
Subsets all forecasts at the index value and aggregates these forecasts into
an h_ahead Forecast object with h_ahead equal to the value passed to the
h_aheads argument.
}
\examples{

# The following forecasts are in time format. Each forecast was made at a
# different time and represents a forecast for a number of h_ahead periods 
# ahead.

forc1_t1 <- Forecast(
  origin = as.Date(c("2010-02-17", "2010-02-17", "2010-02-17")),
  future = as.Date(c("2010-06-30", "2010-09-30", "2010-12-31")),
  forecast = c(4.27, 3.77, 3.52),
  realized = c(4.96, 4.17, 4.26),
  h_ahead = NA
)

forc1_t2 <- Forecast(
  origin = as.Date(c("2010-05-14", "2010-05-14", "2010-05-14")),
  future = as.Date(c("2010-09-30", "2010-12-31", "2011-03-31")),
  forecast = c(3.36, 3.82, 4.22),
  realized = c(4.17, 4.26, 4.99),
  h_ahead = NA
)

forc1_t3 <- Forecast(
  origin = as.Date(c("2010-07-22", "2010-07-22", "2010-07-22")),
  future = as.Date(c("2010-12-31", "2011-03-31", "2011-06-30")),
  forecast = c(4.78, 4.53, 5.03),
  realized = c(4.26, 4.99, 5.33),
  h_ahead = NA
)

forc1_t4 <- Forecast(
  origin = as.Date(c("2010-12-22", "2010-12-22", "2010-12-22")),
  future = as.Date(c("2011-03-31", "2011-06-30", "2011-09-30")),
  forecast = c(5.45, 4.89, 5.78),
  realized = c(4.99, 5.33, 5.21),
  h_ahead = NA
)

forcs <- list(forc1_t1, forc1_t2, forc1_t3, forc1_t4)

convert_byh(forcs, index = 1L, h_aheads = 1)

convert_byh(forcs, index = 1:2, h_aheads = c(1, 2))

}
