% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_code.R
\name{save_code_to_file}
\alias{save_code_to_file}
\title{Save extracted code to file}
\usage{
save_code_to_file(code_string, filename = NULL, language = "r")
}
\arguments{
\item{code_string}{String or character vector containing the code to save}

\item{filename}{Output filename. If NULL, generates a timestamped filename}

\item{language}{Programming language for determining file extension (default: "r")}
}
\value{
The path to the saved file
}
\description{
This function saves extracted code to a file with appropriate extension
based on the programming language.
}
\examples{
\dontrun{
# Extract and save R code
llm_response <- "```r\nplot(1:10)\n```"
code <- extract_r_code(llm_response)
save_code_to_file(code) # Saves as "code_20240101_120000.R"

# Save with custom filename
save_code_to_file(code, "my_plot.R")

# Save Python code with auto extension
py_code <- "import pandas as pd\ndf = pd.DataFrame()"
save_code_to_file(py_code, language = "python") # Creates .py file

# Save multiple code blocks
response <- "```r\nx <- 1\n```\n```r\ny <- 2\n```"
codes <- extract_r_code(response)
save_code_to_file(codes, "combined_code.R")
}

}
