% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-fisherian.R
\name{likelihood_interval}
\alias{likelihood_interval}
\alias{likelihood_interval.fisher_mle}
\title{Likelihood Interval}
\usage{
likelihood_interval(x, ...)

\method{likelihood_interval}{fisher_mle}(x, data, model, k = 8, param = NULL, ...)
}
\arguments{
\item{x}{A fisher_mle object}

\item{...}{Additional arguments passed to optimization}

\item{data}{Data frame used for likelihood computation}

\item{model}{The likelihood model used for fitting}

\item{k}{Likelihood ratio cutoff (default 8, giving 1/8 interval)}

\item{param}{Index or name of parameter for profile interval (NULL for all)}
}
\value{
Matrix with lower and upper bounds for each parameter
}
\description{
Computes the likelihood interval for a parameter:
\code{LI(k) = \{theta : R(theta) >= 1/k\} = \{theta : S(theta) >= -log(k)\}}
}
\details{
Unlike confidence intervals, likelihood intervals make no probability
statements about the parameter. They simply identify the set of
parameter values that are well-supported by the data.

Common choices for k:
\itemize{
\item k = 8: 1/8 likelihood interval (~95\% CI equivalent)
\item k = 15: 1/15 likelihood interval (~99\% CI equivalent)
\item k = 32: 1/32 likelihood interval (~99.9\% CI equivalent)
}

For multivariate parameters, specify \code{param} to get a profile likelihood
interval for that parameter (profiling over the others).
}
