% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_generic.R
\name{lr_parse_generic}
\alias{lr_parse_generic}
\title{Generic function to parse spectra files that don't have a specific parser}
\usage{
lr_parse_generic(filename, decimal = ".", sep = NULL, ...)
}
\arguments{
\item{filename}{Path of the file to parse}

\item{decimal}{Character to be used to identify decimal plates
(defaults to \code{.}).}

\item{sep}{Column delimiting characters to be considered in addition to the
default (which are: tab, space, and ";")}

\item{...}{ignored}
}
\value{
A named list of two elements:
\itemize{
\item \code{data}: a dataframe with columns "wl", "dark", "white", "scope" and
"processed", in this order.
\item \code{metadata}: a character vector with metadata including:
\itemize{
\item \code{user}: Name of the spectrometer operator
\item \code{datetime}: Timestamp of the recording in format '\%Y-\%m-\%d \%H:\%M:\%S'
and UTC timezone. If timezone is missing in source file, UTC time will
be assumed (for reproducibility purposes across computers with different
localtimes).
\item \code{spec_model}: Model of the spectrometer
\item \code{spec_ID}: Unique ID of the spectrometer
\item \code{white_inttime}: Integration time of the white reference (in ms)
\item \code{dark_inttime}: Integration time of the dark reference (in ms)
\item \code{sample_inttime}: Integration time of the sample (in ms)
\item \code{white_avgs}: Number of averaged measurements for the white reference
\item \code{dark_avgs}: Number of averaged measurements for the dark reference
\item \code{sample_avgs}: Number of averaged measurements for the sample
\item \code{white_boxcar}: Boxcar width for the white reference
\item \code{dark_boxcar}: Boxcar width for the dark reference
\item \code{sample_boxcar}: Boxcar width for the sample reference
}
}
}
\description{
Generic function to parse spectra files that don't have a specific parser
}
\details{
'processed' column computed by official software and provided as is.
}
\examples{
res_csv <- lr_parse_generic(
  system.file("testdata", "spec.csv", package = "lightr"),
  sep = ","
)
head(res_csv$data)
# No metadata is extracted with this parser
res_csv$metadata

res_craic <- lr_parse_generic(
  system.file("testdata", "CRAIC_export.txt", package = "lightr")
)
head(res_craic$data)
# No metadata is extracted with this parser
res_craic$metadata

}
