% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/less-regressor.R
\name{LESSBase}
\alias{LESSBase}
\title{LESSBase}
\value{
R6 class of LESSBase
}
\description{
The base class for LESSRegressor and LESSClassifier
}
\section{Super classes}{
\code{\link[less:BaseEstimator]{less::BaseEstimator}} -> \code{\link[less:SklearnEstimator]{less::SklearnEstimator}} -> \code{LESSBase}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-LESSBase-new}{\code{LESSBase$new()}}
\item \href{#method-LESSBase-set_random_state}{\code{LESSBase$set_random_state()}}
\item \href{#method-LESSBase-get_n_subsets}{\code{LESSBase$get_n_subsets()}}
\item \href{#method-LESSBase-get_n_neighbors}{\code{LESSBase$get_n_neighbors()}}
\item \href{#method-LESSBase-get_frac}{\code{LESSBase$get_frac()}}
\item \href{#method-LESSBase-get_n_replications}{\code{LESSBase$get_n_replications()}}
\item \href{#method-LESSBase-get_d_normalize}{\code{LESSBase$get_d_normalize()}}
\item \href{#method-LESSBase-get_scaling}{\code{LESSBase$get_scaling()}}
\item \href{#method-LESSBase-get_val_size}{\code{LESSBase$get_val_size()}}
\item \href{#method-LESSBase-get_random_state}{\code{LESSBase$get_random_state()}}
\item \href{#method-LESSBase-get_isFitted}{\code{LESSBase$get_isFitted()}}
\item \href{#method-LESSBase-get_replications}{\code{LESSBase$get_replications()}}
\item \href{#method-LESSBase-clone}{\code{LESSBase$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_all_fields"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_all_fields'><code>less::BaseEstimator$get_all_fields()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="BaseEstimator" data-id="get_attributes"><a href='../../less/html/BaseEstimator.html#method-BaseEstimator-get_attributes'><code>less::BaseEstimator$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="fit"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-fit'><code>less::SklearnEstimator$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="get_type"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-get_type'><code>less::SklearnEstimator$get_type()</code></a></span></li>
<li><span class="pkg-link" data-pkg="less" data-topic="SklearnEstimator" data-id="predict"><a href='../../less/html/SklearnEstimator.html#method-SklearnEstimator-predict'><code>less::SklearnEstimator$predict()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-new"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of R6 Class of LESSBase
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$new(replications = NULL, scobject = NULL, isFitted = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{replications}}{List to store the replications}

\item{\code{scobject}}{Scaling object used for normalization (less::StandardScaler)}

\item{\code{isFitted}}{Flag to check whether LESS is fitted}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-set_random_state"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-set_random_state}{}}}
\subsection{Method \code{set_random_state()}}{
Auxiliary function that sets random state attribute of the self class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$set_random_state(random_state)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{random_state}}{seed number to be set as random state}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-get_n_subsets"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-get_n_subsets}{}}}
\subsection{Method \code{get_n_subsets()}}{
Auxiliary function returning the number of subsets
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$get_n_subsets()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-get_n_neighbors"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-get_n_neighbors}{}}}
\subsection{Method \code{get_n_neighbors()}}{
Auxiliary function returning the number of neighbors
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$get_n_neighbors()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-get_frac"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-get_frac}{}}}
\subsection{Method \code{get_frac()}}{
Auxiliary function returning the percentage of samples used to set the number of neighbors
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$get_frac()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-get_n_replications"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-get_n_replications}{}}}
\subsection{Method \code{get_n_replications()}}{
Auxiliary function returning the number of replications
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$get_n_replications()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-get_d_normalize"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-get_d_normalize}{}}}
\subsection{Method \code{get_d_normalize()}}{
Auxiliary function returning the flag for normalization
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$get_d_normalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-get_scaling"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-get_scaling}{}}}
\subsection{Method \code{get_scaling()}}{
Auxiliary function returning the flag for scaling
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$get_scaling()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-get_val_size"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-get_val_size}{}}}
\subsection{Method \code{get_val_size()}}{
Auxiliary function returning the validation set size
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$get_val_size()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-get_random_state"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-get_random_state}{}}}
\subsection{Method \code{get_random_state()}}{
Auxiliary function returning the random seed
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$get_random_state()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-get_isFitted"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-get_isFitted}{}}}
\subsection{Method \code{get_isFitted()}}{
Auxiliary function returning the isFitted flag
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$get_isFitted()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-get_replications"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-get_replications}{}}}
\subsection{Method \code{get_replications()}}{
Auxiliary function returning the isFitted flag
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$get_replications()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-LESSBase-clone"></a>}}
\if{latex}{\out{\hypertarget{method-LESSBase-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LESSBase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
