% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{rWAR}
\alias{rWAR}
\title{Random matrix generation from first-order autoregressive Wishart process}
\usage{
rWAR(n, M, Sigma, K = 1L, order = 1L, burnin = 25L)
}
\arguments{
\item{n}{sample size}

\item{M}{matrix of autoregressive coefficients}

\item{Sigma}{covariance matrix}

\item{K}{integer, degrees of freedom}

\item{order}{order of autoregressive process, only \code{1} is supported at current.}

\item{burnin}{number of iterations discarded}
}
\value{
an array of size \code{d} by \code{d} by \code{n} containing the samples
}
\description{
Given a matrix of coefficients \code{M} and a covariance matrix \code{Sigma},
simulate \code{n} random matrices from a first-order autoregressive Wishart process
by simulating from cross-products of vector autoregressions
}
\examples{
M <- matrix(c(0.3, -0.3, -0.3, 0.3), nrow = 2)
Sigma <- matrix(c(1, 0.5, 0.5, 1), nrow = 2)
rWAR(n = 10, M = M, Sigma = Sigma, K = 5)
}
\references{
C. Gourieroux, J. Jasiak, and R. Sufana (2009). The Wishart Autoregressive process of multivariate stochastic volatility, \emph{Journal of Econometrics}, 150(\bold{2}), 167-181, <doi:10.1016/j.jeconom.2008.12.016>.
}
