% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.khazard.R
\name{plot.khazard}
\alias{plot.khazard}
\title{Plot of kernel hazard estimate from an object of class khazard}
\usage{
\method{plot}{khazard}(x, h = NULL, ylim, type, xlab, ylab, main, ...)
}
\arguments{
\item{x}{Object of class khazard}

\item{h}{bandwidth for which hazard function estimate will be plot if x$h is vector}

\item{ylim}{Limits for the y axis.}

\item{type}{type argument for plot.}

\item{xlab}{Label for the x axis.}

\item{ylab}{Label for the y axis.}

\item{main}{Title of plot.}

\item{...}{Additional arguments.}
}
\description{
Plot of kernel hazard estimate from an object of class khazard
}
\examples{
library(survival)
fit<-khazard(times = lung$time,delta = lung$status-1)
plot(fit)

fit<-khazard(times = lung$time,delta = lung$status-1,h=c(100,150,200,250), value="both")
plot(fit,h=200)
}
\seealso{
\code{\link{khazard}}
}
