% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pretty_print_journal.R
\name{format_metric_cols}
\alias{format_metric_cols}
\title{Format multiple data.frame 'mean_*' columns for presentation (by metric).}
\usage{
format_metric_cols(
  df,
  metric,
  var_prefix = "mean",
  rate_unit = NULL,
  mag = NULL,
  style_name = "nature"
)
}
\arguments{
\item{df}{[data.table] input data.table with one or more 'mean_' columns}

\item{metric}{[chr c('prop', 'pp', 'count', 'rate')] a single metric}

\item{var_prefix}{[chr: default 'mean'] prefix of mean variable names to
format.  Implemented as e.g. "^mean[_]+" to capture 'mean', 'mean_1990',
'mean_2000', etc.}

\item{rate_unit}{[chr: default NULL] unit label for rates (e.g., "deaths", "cases").
Required when metric = "rate", ignored otherwise.}

\item{mag}{[chr: default NULL] magnitude override - see set_magnitude()
- For props/pp: "as-is" (no scaling, use values as provided)
- For counts: "t" (thousand), "m" (million), "b" (billion)
- For rates: "per10", "per100", "per1k", ..., "per10b"}

\item{style_name}{[chr: default 'nature'] style name - controls rounding and
formatting.}
}
\value{
[data.table] copy of input data.table with formatted mean column(s)
}
\description{
Format one or more 'mean_' columns by magnitude, metric, and style.
}
\examples{
df <- data.frame(
  location_id = c(1, 2, 3)
  , mean_1990 = c(100, 1e6, 1e9)
  , mean_2000 = c(200, 2e6, 2e-1)
 )
format_metric_cols(df, metric = "count")
}
\seealso{
Other styled_formats: 
\code{\link{format_journal_clu}()},
\code{\link{format_journal_df}()},
\code{\link{format_lancet_clu}()},
\code{\link{format_lancet_df}()},
\code{\link{format_nature_clu}()},
\code{\link{format_nature_df}()},
\code{\link{fround_clu_triplet}()},
\code{\link{new_style}()}
}
\concept{styled_formats}
