% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join_explain.R
\name{join_diff}
\alias{join_diff}
\title{Compare Data Frame Before and After Join}
\usage{
join_diff(before, after, by = NULL)
}
\arguments{
\item{before}{The original data frame (before joining).}

\item{after}{The result data frame (after joining).}

\item{by}{Optional. Column names to analyze for key statistics.}
}
\value{
Invisibly returns a comparison summary. Prints a formatted comparison.
}
\description{
Shows a side-by-side comparison of key statistics before and after a join
operation.
}
\examples{
before <- data.frame(id = 1:3, x = letters[1:3])
after <- data.frame(id = c(1, 2, 2, 3), x = c("a", "b", "b", "c"), y = 1:4
)

join_diff(before, after)

}
\seealso{
\code{\link[=join_explain]{join_explain()}}, \code{\link[=join_spy]{join_spy()}}
}
