% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.bcmeta.R
\name{plot.bcmeta}
\alias{plot.bcmeta}
\title{Generic plot function for bcmeta object.}
\usage{
\method{plot}{bcmeta}(
  x,
  n.samples = NULL,
  x.lim = NULL,
  y.lim = NULL,
  x.lab = expression(theta^{
     new
 }),
  y.lab = "Posterior Predictive Distribution",
  title.plot = "Bias-Corrected Meta-Analysis",
  show.histogram = TRUE,
  show.rug = TRUE,
  binwidth = 0.08,
  adjust = 1,
  density.color = "blue",
  density.lty = "solid",
  density.lwd = 1,
  density.alpha = 0.2,
  hist.color = "black",
  hist.fill = "grey95",
  rug.color = "green",
  rug.alpha = 0.5,
  ...
)
}
\arguments{
\item{x}{The object generated by the bcmeta function.}

\item{n.samples}{The number of posterior samples to plot.}

\item{x.lim}{Numeric vector of length 2 specifying the x-axis limits.}

\item{y.lim}{Numeric vector of length 2 specifying the y-axis limits.}

\item{x.lab}{Text with the label of the x-axis. Defaults to "Treatment Effect".}

\item{y.lab}{Text with the label of the y-axis. Defaults to "Posterior Predictive Distribution".}

\item{title.plot}{Text for setting a title in the plot. Defaults to "Bias-Corrected Meta-Analysis".}

\item{show.histogram}{A logical value indicating whether to show the histogram.}

\item{show.rug}{A logical value indicating whether to show the rug plot.}

\item{binwidth}{A numeric value specifying the bin width for the histogram. Defaults to 0.08.}

\item{adjust}{A numeric value to adjust the bandwidth of the density curves. Defaults to 1.}

\item{density.color}{A character value for the density curve color. Defaults to "blue".}

\item{density.lty}{A character value for the density curve line type. Defaults to "solid".}

\item{density.lwd}{A numeric value for the density curve line width. Defaults to 1.}

\item{density.alpha}{A numeric value between 0 and 1 for the density curve transparency. Defaults to 0.2.}

\item{hist.color}{A character value for the histogram border color. Defaults to "black".}

\item{hist.fill}{A character value for the histogram fill color. Defaults to "grey95".}

\item{rug.color}{A character value for the rug plot color. Defaults to "green".}

\item{rug.alpha}{A numeric value between 0 and 1 for the rug plot transparency. Defaults to 0.5.}

\item{...}{\dots}
}
\description{
This function is built with `ggplot2`. Parameters such as `binwidth`, `adjust`,
`density.color`, `density.lwd`, `density.lty`, and `density.alpha` correspond
directly to arguments in the `ggplot2` geoms.
}
