% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R
\name{design}
\alias{design}
\title{Generating design matrices}
\usage{
design(formula, data, subset, treat, orig.names)
}
\arguments{
\item{formula}{Formula with which to generate the design matrix.}

\item{data}{\code{data.frame} with which to generate the design
matrix.}

\item{subset}{Condition to select subset of data.}

\item{treat}{The name of the treatment variable. This should only
be passed when constructing OLS weights.}

\item{orig.names}{character vector of the terms in the final design
matrix. This is required when the user declares an IV-like
formula where the treatment variable is passed into the
\code{factor} function. Since the treatment variable has to be
fixed to 0 or 1, the design matrix will be unable to construct
the contrasts. The argument \code{orig.names} is a vector of
the terms in the IV-like specification prior to fixing the
treatment variable.}
}
\value{
Three matrices are returned: one for the outcome variable,
    Y; one for the second stage covariates, X; and one for the
    first stage covariates, Z.
}
\description{
This function generates the design matrix given an IV
specification.
}
\examples{
dtm <- ivmte:::gendistMosquito()
design(formula = ey ~ d | z,
           data = dtm,
           subset = z \%in\% c(1, 2))

}
