% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simHK.R
\name{simHK}
\alias{simHK}
\title{IFS similarity measure simHK}
\usage{
simHK(ma, na, mb, nb, k)
}
\arguments{
\item{ma}{IFS membership values for the data set x computed using either triangular or trapezoidal or guassian membership function}

\item{na}{IFS non-membership values for the data set x computed using either Sugeno and Terano's  or Yager's non-membership function}

\item{mb}{IFS membership values for the data set y computed using either triangular or trapezoidal or guassian membership function}

\item{nb}{IFS non-membership values for the data set y computed using either Sugeno and Terano's  or Yager's non-membership function}

\item{k}{A constant value, considered as 1}
}
\value{
The IFS similarity values of data set y with data set x
}
\description{
IFS similarity measure values using simHK computation technique with membership, and non-membership values of two objects or set of objects.
}
\examples{
x<-matrix(c(12,9,14,11,21,16,15,24,20,17,14,11),nrow=4)
y<-matrix(c(11,21,6),nrow=1)
a<-mn(x)
b<-std(x)
a1<-mn(y)
b1<-std(y)
lam<-0.5
ma<-memG(a,b,x)
na<-nonmemS(ma,lam)
mb<-memG(a1,b1,y)
nb<-nonmemS(mb,lam)
k<-1
simHK(ma,na,mb,nb,k)
#[1] 0.9702837 0.9702706 0.9874349 0.9874349
}
\references{
D. H. Hong and C. Kim. A note on similarity measures between vague sets and between elements. Information sciences, 115(1-4):83 - 96, 1999.
}
