% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iface-class.R
\name{get_iface}
\alias{get_iface}
\title{Extract the \code{interfacer} specification for a function}
\usage{
get_iface(fn, param = names(formals(fn))[[1]])
}
\arguments{
\item{fn}{the function}

\item{param}{the parameter name (defaults to first parameter)}
}
\value{
the \code{iface} on the parameter
}
\description{
Extract the \code{interfacer} specification for a function
}
\examples{

my_iface = iface(
  col1 = integer + group_unique ~ "an integer column",
  .default = test_df
)

# the function x defines a formal `df` with default value of `my_iface`
# this default value is used to validate the structure of the user supplied
# value when the function is called.
x = function(df = my_iface, ...) {
  df = ivalidate(df,...)
  return(df)
}

get_iface(x,"df")
}
