% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integrands.R
\name{logit_integrand}
\alias{logit_integrand}
\title{Default integrand for the group-level propensity score}
\usage{
logit_integrand(b, X, A, parameters, allocation = A, randomization = 1)
}
\arguments{
\item{b}{vector argument of values necessary for \code{\link{integrate}}.}

\item{X}{n by length(fixed effects) matrix of covariates.}

\item{A}{vector of binary treatments}

\item{parameters}{vector of fixed effect (and random effect if applicable). 
Random effect should be last element in vector.}

\item{allocation}{The allocation strategy. Defaults to A so that is essentially 
ignored if allocation is not set to a value within (0, 1).}

\item{randomization}{Randomization probability. Defaults to 1.}
}
\value{
value of the integrand
}
\description{
Computes the following function:
\deqn{\prod_{j=1}^{n} (r h_{j}(b))^{A_j}  (1 - r h_{j}(b))^{1 - A_j} 
f_b(b; \theta_b)}{ prod(r * plogis(X * fixef + b)^A * 
(1 - r * plogis(X * fixef+ b))^(1 - A)) * 
dnorm(sd = sqrt(ranef))} 
where \eqn{r} is the randomization scheme. \eqn{X} is the covariate(s) vectors. 
\eqn{fixef} is the vector of fixed effects. \eqn{b} is the random (group-level) effect.
\eqn{ranef} is the random effect variance.
}
