% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{contagious_diseases_df}
\alias{contagious_diseases_df}
\title{Contagious Disease Data for US States}
\format{
A data frame with 16,065 observations and 6 variables:
\describe{
  \item{disease}{Factor with 7 levels indicating the disease type}
  \item{state}{Factor with 51 levels indicating the US state}
  \item{year}{Numeric vector indicating the year of observation}
  \item{weeks_reporting}{Numeric vector indicating the number of weeks reported}
  \item{count}{Numeric vector indicating the number of cases reported}
  \item{population}{Numeric vector indicating the population of the state in that year}
}
}
\source{
Data taken from the dslabs package version 0.8.0. Original data courtesy of the Tycho Project (\url{http://www.tycho.pitt.edu/}).
}
\usage{
data(contagious_diseases_df)
}
\description{
This dataset, \code{contagious_diseases_df}, is a data frame containing yearly counts
for Hepatitis A, Measles, Mumps, Pertussis, Polio, Rubella, and Smallpox for US states.
The original data is courtesy of the Tycho Project.
}
\details{
The dataset name has been kept as \code{contagious_diseases_df} to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
infectiousR package and assists users in identifying its specific characteristics.
The suffix \code{_df} indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
