% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/negativeBionomial.R
\docType{class}
\name{negativeBinomial}
\alias{negativeBinomial}
\title{Bayesian Negative Binomial Model Factory}
\description{
Bayesian Negative Binomial Model Factory

Bayesian Negative Binomial Model Factory
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{version}}{Package version used to fit the model}

\item{\code{mcmChecks}}{MCMC diagnostics}

\item{\code{credible_interval}}{Credible interval for the treatment effect}

\item{\code{tau_draws}}{Posterior draws for the treatment effect}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-bnb-new}{\code{negativeBinomial$new()}}
\item \href{#method-bnb-tracePlot}{\code{negativeBinomial$tracePlot()}}
\item \href{#method-bnb-posteriorProb}{\code{negativeBinomial$posteriorProb()}}
\item \href{#method-bnb-pointEstimate}{\code{negativeBinomial$pointEstimate()}}
\item \href{#method-bnb-credibleInterval}{\code{negativeBinomial$credibleInterval()}}
\item \href{#method-bnb-vizdraws}{\code{negativeBinomial$vizdraws()}}
\item \href{#method-bnb-clone}{\code{negativeBinomial$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bnb-new"></a>}}
\if{latex}{\out{\hypertarget{method-bnb-new}{}}}
\subsection{Method \code{new()}}{
Create a new Bayesian Negative Binomial Model object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{negativeBinomial$new(
  data,
  y,
  x,
  treatment,
  tau_mean,
  tau_sd,
  run_estimation = 1,
  seed = 1982,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{Data frame to be used}

\item{\code{y}}{Name of the outcome variable in the data frame}

\item{\code{x}}{Vector of names of all covariates in the data frame}

\item{\code{treatment}}{Name of the treatment indicator variable in the data frame}

\item{\code{tau_mean}}{Prior mean for the treatment effect estimation}

\item{\code{tau_sd}}{Prior standard deviation for the treatment effect estimation}

\item{\code{run_estimation}}{Integer flag to control whether estimation is run (1) or not (0)}

\item{\code{seed}}{Seed for Stan fitting}

\item{\code{...}}{Additional arguments for Stan}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
invisible
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bnb-tracePlot"></a>}}
\if{latex}{\out{\hypertarget{method-bnb-tracePlot}{}}}
\subsection{Method \code{tracePlot()}}{
Plot MCMC trace for the eta and sigma parameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{negativeBinomial$tracePlot(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments for Stan}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A ggplot object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bnb-posteriorProb"></a>}}
\if{latex}{\out{\hypertarget{method-bnb-posteriorProb}{}}}
\subsection{Method \code{posteriorProb()}}{
Calculate posterior probability of effect exceeding a threshold

This function calculates the posterior probability of the effect
being larger or smaller than a specified threshold.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{negativeBinomial$posteriorProb(threshold = 0, gt = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{threshold}}{A numeric value specifying the threshold.}

\item{\code{gt}}{A logical value indicating whether to calculate the probability
of the effect being greater than (TRUE) or less than (FALSE)
the threshold.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function uses the private$..tau_draws internal variable
to obtain draws from the posterior distribution of the effect size.
Based on the specified arguments, the function calculates the
proportion of draws exceeding/falling below the threshold and
returns a formatted statement describing the estimated probability.

Calculate point estimate of the effect

This R6 method calculates the point estimate of the effect size
based on the posterior draws of the tau parameter.
}

\subsection{Returns}{
A character string summarizing the estimated probability.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bnb-pointEstimate"></a>}}
\if{latex}{\out{\hypertarget{method-bnb-pointEstimate}{}}}
\subsection{Method \code{pointEstimate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{negativeBinomial$pointEstimate(median = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{median}}{Logical value. If TRUE (default), the median of
the tau draws is returned. If FALSE, the mean is returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method uses the private$..tau_draws internal variable
which contains MCMC draws of the tau parameter representing the
effect size. Based on the specified median argument, the method
calculates and returns either the median or the mean of the draws.
Calculates credible interval for the effect of the intervention

This R6 method calculates and returns a formatted statement summarizing
the credible interval of a specified width for the effect of the intervention.
}

\subsection{Returns}{
A numeric value representing the point estimate.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bnb-credibleInterval"></a>}}
\if{latex}{\out{\hypertarget{method-bnb-credibleInterval}{}}}
\subsection{Method \code{credibleInterval()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{negativeBinomial$credibleInterval(width = 0.75, round = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{width}}{Numeric value between 0 and 1 representing the desired
width of the credible interval (e.g., 0.95 for a 95\% credible interval).}

\item{\code{round}}{Integer value indicating the number of decimal places to round
the lower and upper bounds of the credible interval.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This method uses the private$..tau_draws internal variable
containing MCMC draws of the tau parameter representing the effect
size. It calculates the credible interval, stores it internally, and
returns a formatted statement summarizing the findings.
}

\subsection{Returns}{
A character string with the following information:
\itemize{
\item The probability associated with the specified width
\item The lower and upper bounds of the credible interval, rounded to the
specified number of decimal places
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bnb-vizdraws"></a>}}
\if{latex}{\out{\hypertarget{method-bnb-vizdraws}{}}}
\subsection{Method \code{vizdraws()}}{
Plots impact's prior and posterior distributions.

For more details see \code{\link[vizdraws:vizdraws]{vizdraws::vizdraws()}}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{negativeBinomial$vizdraws(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{other arguments passed to vizdraws.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An interactive plot of the prior and posterior distributions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-bnb-clone"></a>}}
\if{latex}{\out{\hypertarget{method-bnb-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{negativeBinomial$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
