% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imagine-main.R
\name{contextualMF}
\alias{contextualMF}
\title{Performs Contextual Median Filter}
\usage{
contextualMF(X)
}
\arguments{
\item{X}{A numeric \code{matrix} object used for apply filters.}
}
\value{
\code{contextualMF} returns a \code{matrix} object with the same
dimensions of \code{X}.
}
\description{
This function implements the Contextual Median Filter (CMF)
algorithm, which was first described by Belkin & O'Reilly (2009), following
the pseudocode provided in their paper.
}
\details{
Following the definition of CMF, since \strong{imagine} v.2.0.0, \code{times}
argument will not be available anymore.

\strong{imagine} offers the CMF algorithm but for the using to find out
oceanographic fronts, it is recommended to see and use the functions of the
\href{https://CRAN.R-project.org/package=grec}{\strong{grec}} package.
}
\examples{
data(wbImage)

cmfOut <- contextualMF(X = wbImage)

# image(cmfOut)
}
\references{
Belkin, I. M., & O'Reilly, J. E. (2009). An algorithm for oceanic
front detection in chlorophyll and SST satellite imagery. Journal of Marine
Systems, 78(3), 319-326 (\doi{http://dx.doi.org/10.1016/j.jmarsys.2008.11.018}).
}
