% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClaimsByLinkRatio.R
\name{claims_by_link_ratio}
\alias{claims_by_link_ratio}
\title{Claims by link ratio}
\usage{
claims_by_link_ratio(tbl_claims, links, lags)
}
\arguments{
\item{tbl_claims}{A claims data frame}

\item{links}{A vector of the same length as `lags` of factors, or their
distributions, determining how severities change from one evaluation date
to the next.}

\item{lags}{A vector of lags}
}
\value{
A claims data frame
}
\description{
Given a data frame of claims, this will simulate claim development by applying a (possibly) random link ratio.
}
\details{
This function will apply the link ratio algorithm at an individual claim level.
}
\examples{

tbl_policy <- policy_year_new(10, 2001)
tbl_claims <- claims_by_first_report(
               tbl_policy,
               frequency = 10,
               payment_severity = 100,
               lags = 1)
tbl_claims <- claims_by_link_ratio(
               tbl_claims,
               links = c(1.25, 1.1, 1.05),
               lags = 1:4)

}
