% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_ieegio_transform.R
\name{as_ieegio_transform}
\alias{as_ieegio_transform}
\alias{as_ieegio_transform.NULL}
\alias{as_ieegio_transform.character}
\alias{as_ieegio_transform.matrix}
\alias{as_ieegio_transform.array}
\alias{as_ieegio_transform.list}
\alias{as_ieegio_transform.ieegio_transforms}
\title{Convert to ieegio transform}
\usage{
as_ieegio_transform(x, ...)

\method{as_ieegio_transform}{`NULL`}(x, space_from = "", space_to = "", ...)

\method{as_ieegio_transform}{character}(x, format = c("ants", "flirt"), ...)

\method{as_ieegio_transform}{matrix}(x, space_from = "", space_to = "", ...)

\method{as_ieegio_transform}{array}(x, space_from = "", space_to = "", ...)

\method{as_ieegio_transform}{list}(x, ...)

\method{as_ieegio_transform}{ieegio_transforms}(x, ...)
}
\arguments{
\item{x}{object to convert (character path, matrix, array, list, or existing transform)}

\item{...}{additional arguments passed to methods}

\item{space_from}{source space for matrix/array methods. Default \code{""} is
a wildcard for arbitrary space name.}

\item{space_to}{target space for matrix/array methods. Default \code{""} is
a wildcard for arbitrary space name.}

\item{format}{character string specifying the file format for character paths.
Supports \code{"ants"} (default) for ANTs format and \code{"flirt"} for
FSL FLIRT format. Only used for character method.}
}
\value{
An \code{ieegio_transforms} object
}
\description{
Generic function to convert various objects into \code{ieegio_transforms}.
}
\details{
Methods available:
\itemize{
\item \code{character}: Reads transform from file (uses \code{io_read_ants_transform}
or \code{io_read_flirt_transform} depending on \code{format})
\item \code{matrix}: Creates transform from matrix
\item \code{array}: Creates transform from 2D array
\item \code{list}: Creates transform chain from list of transforms
\item \code{ieegio_transforms}: Returns input unchanged
}
}
