% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Main_Function.R
\name{iSTAY_Single}
\alias{iSTAY_Single}
\title{Calculate stability for a single time series.}
\usage{
iSTAY_Single(
  data,
  order.q = c(1, 2),
  Alltime = TRUE,
  start_T = NULL,
  end_T = NULL
)
}
\arguments{
\item{data}{A \code{vector} of time series data, or a \code{data.frame} with sampling units as rows and time points as columns.}

\item{order.q}{a numerical vector specifying the orders of stability. Default is c(1,2).}

\item{Alltime}{Logical (\code{TRUE} or \code{FALSE}), indicating whether to use all time points in the data.}

\item{start_T}{(Applicable only if \code{Alltime = FALSE}) a positive integer specifying the starting column (time point) for the analysis interval.}

\item{end_T}{(Applicable only if \code{Alltime = FALSE}) a positive integer specifying the ending column (time point) for the analysis interval.}
}
\value{
a dataframe with columns: \cr
Dataset: the input dataset \cr
Order_q: order of stability \cr
Stability: stability measures of order q
}
\description{
\code{iSTAY_Single} computes the stability of order q for a single time series.
}
\examples{
# Compute the stability of individual plots
data("Data_Jena_20_metacommunities")
individual_plots <- do.call(rbind, Data_Jena_20_metacommunities)
output_individual_plots <- iSTAY_Single(data = individual_plots, 
                                        order.q=c(1,2), Alltime = TRUE)
output_individual_plots

# Compute the stability of individual populations
data("Data_Jena_76_metapopulations")
individual_populations <- do.call(rbind, Data_Jena_76_metapopulations)
output_individual_populations <- iSTAY_Single(data = individual_populations, 
                                              order.q = c(1,2), Alltime = TRUE)
output_individual_populations

}
