% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_match_class.R
\docType{class}
\name{graphMatch-class}
\alias{graphMatch-class}
\alias{graphMatch}
\alias{as.graphMatch}
\title{Graph matching results class}
\usage{
graphMatch(corr, nnodes, call = NULL, detail = list())

as.graphMatch(from)
}
\arguments{
\item{corr}{data.frame indicating the correspondence between two graphs}

\item{nnodes}{dimensions of the original two graphs}

\item{call}{The call to the graph matching function}

\item{detail}{List with other more detailed information}

\item{from}{object to convert to graphMatch object}
}
\value{
graphMatch object
}
\description{
An S4 class for the results of a graph matching function
}
\details{
graphMatch objects are returned by any of the graph matching methods
  implemented in the iGraphMatch package. These objects are primarily to
  represent the found correspondence between the two vertex sets. This is
  represented by a data.frame with two columns indicating the aligned
  vertex-pairs across the two graphs.
}
\section{Slots}{

\describe{
\item{\code{corr}}{data.frame indicating the correspondence between two graphs}

\item{\code{nnodes}}{of the original two graphs}

\item{\code{call}}{The call to the graph matching function}
}}

\examples{
# sample a pair of correlated random graphs from G(n,p)
set.seed(123)
cgnp_pair <- sample_correlated_gnp_pair(n = 10, corr =  0.3, p =  0.5)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2

# match g1 & g2 using percolation algorithm with some known node pairs as seeds
match <- gm(A = g1, B = g2, seeds = 1:3, method = 'indefinite')

# graphMatch object
match

match$corr_A # matching correspondence in the first graph
match$corr_B # matching correspondence in the second graph
match$seeds # vector of logicals indicating seeded nodes

as.data.frame(match)
match[]
dim(match)
length(match)

# matching details unique to the FW methodology with indefinite relaxation
match$iter # number of iterations
match$soft # doubly stochastic matrix from the last iteration, can be used to extract soft matching
match$lap_method # method for solving lap

# create a graphMatch object from a data.frame or matrix
as.graphMatch(data.frame(1:5, 1:5))
as.graphMatch(1:5)

}
\seealso{
\link[iGraphMatch:as.data.frame,graphMatch-method]{graphMatch_methods},
\link[iGraphMatch:summary,graphMatch-method]{graphMatch_summary},
\link[iGraphMatch:\%*\%,graphMatch,ANY-method]{graphMatch_operators},
\link[iGraphMatch:plot,igraph,igraph-method]{graphMatch_plot}
}
