% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hypergate.R
\name{hgate_info}
\alias{hgate_info}
\title{hgate_info}
\usage{
hgate_info(hgate, xp, gate_vector, level, beta = 1)
}
\arguments{
\item{hgate}{A hypergate object (produced by hypergate())}

\item{xp}{The expression matrix from which the 'hgate' parameter originates,
needed for Fscore computation}

\item{gate_vector}{Categorical data from which the 'hgate' parameter
originates, needed for Fscore computation}

\item{level}{Level of gate_vector identifying the population of interest,
needed for Fscore computation}

\item{beta}{Beta to weight purity (low beta) or yield (high beta) more,
needed for Fscore computation}
}
\value{
A data.frame with channel, sign, comp and threshold columns, and
  optionnally deltaF (score deterioration when parameter is ignored),Fscore1d (F_value when using only this parameter) and Fscore (F score when all parameters up to this one are included). Fscores are computed if xp, gate_vector
  and level are passed to the function.
}
\description{
Extract information about a hypergate return: the channels of
  the phenotype, the sign of the channels, the sign of the comparison, the
  thresholds. The function could also compute the Fscores if the xp,
  gate_vector and level parameters are given.
}
\examples{
data(Samusik_01_subset)
xp=Samusik_01_subset$xp_src[,Samusik_01_subset$regular_channels]
gate_vector=Samusik_01_subset$labels
hg=hypergate(xp=xp,gate_vector=gate_vector,level=23,delta_add=0.01)
hgate_info(hgate=hg)
hgate_pheno(hgate=hg)
hgate_rule(hgate=hg)
}
\seealso{
\code{hg_pheno}, \code{hg_rule}
}
