% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fill_value.R
\name{fill_value}
\alias{fill_value}
\title{Fill a time interval in a data frame with a specific numeric value}
\usage{
fill_value(df, col, value, from, to)
}
\arguments{
\item{df}{data frame with the first column being the date and the others numeric variables.}

\item{col}{numeric vector with column(s) number(s) to be filled.}

\item{value}{numeric or \code{NA_real_}. This numeric vector contains the elements to be fill in.}

\item{from}{character, Date or POSIXct with the first date to be filled.}

\item{to}{character, Date or POSIXct with the last date to be filled.}
}
\value{
A data frame filled with the \option{value} in the specified time period.
}
\description{
Assign specific values to a time interval.
}
\examples{
# Create a data frame
dates   <- seq.Date(from = as.Date('1990-01-01'), to = as.Date('1990-12-01'), by = 'm')
met_var <- runif(n = 12, 0, 10)

met_serie <- data.frame(dates, met_var)

# Fill serie
met_fill <- fill_serie(df = met_serie, colName = 'Temp', timeStep = 'day')

# Now fill value
met_fill <- fill_value(df = met_fill, col = 2, value = 10, from = '1990-02-01', to = '1990-02-15')

}
