% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/armitage.R
\name{armitage_estimate_sarea}
\alias{armitage_estimate_sarea}
\title{Estimate well surface area}
\usage{
armitage_estimate_sarea(
  tcdata = NA,
  user_assay_parameters = NA,
  this.well_number = 384,
  this.cell_yield = NA,
  this.v_working = NA
)
}
\arguments{
\item{tcdata}{A data table with well_number corresponding to plate format,
optionally include v_working, sarea, option.bottom, and option.plastic OR 
with assay_component_endpoint_name corresponding to an entry in invitro.assay.params.}

\item{user_assay_parameters}{option to fill in your own assay parameters (data table)}

\item{this.well_number}{For single value, plate format default is 384, used
if is.na(tcdata)==TRUE}

\item{this.cell_yield}{For single value, optionally supply cell_yield,
otherwise estimated based on well number}

\item{this.v_working}{For single value, optionally supply working volume,
otherwise estimated based on well number (m^3)}
}
\value{
A data table composed of any input data.table \emph{tcdata}
with only the following columns either created or altered by this function:  
\tabular{ccc}{
\strong{Column Name} \tab \strong{Description} \tab \strong{Units} \cr
well_number \tab number of wells on plate \tab \cr
sarea \tab surface area \tab m^2 \cr
cell_yield \tab number of cells \tab cells \cr 
v_working \tab working (filled) volume of each well \tab uL \cr
v_total \tab total volume of each well \tab uL \cr
}
}
\description{
Estimate geometry surface area of plastic in well plate based on well plate
format suggested values from Corning.  option.plastic == TRUE (default) give
nonzero surface area (sarea, m^2) option.bottom == TRUE (default) includes
surface area of the bottom of the well in determining sarea.  Optionally
include user values for working volume (v_working, m^3) and surface area.
}
\references{
\insertRef{armitage2014application}{httk}
}
\author{
Greg Honda, Meredith Scherer
}
