% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gwaspoly_helper_functions.R
\name{GWAS_data_from_gwaspoly}
\alias{GWAS_data_from_gwaspoly}
\title{Extracts information from GWASpoly output}
\usage{
GWAS_data_from_gwaspoly(gwaspoly_output, traits = NULL, models = NULL)
}
\arguments{
\item{gwaspoly_output}{A \code{GWASpoly.fitted} or \code{GWASpoly.thresh} object
(returned by \code{GWASpoly::GWASpoly()} or \code{GWASpoly::set.threshold()} functions).}

\item{traits}{Character vector, traits for which GWAS results should be
extracted. If \code{NULL} (default value), all traits present are considered.}

\item{models}{Character vector, genetic models for which GWAS results should be
extracted. If \code{NULL} (default value), all genetic models present are considered.}
}
\value{
A list with the following elements:
\itemize{
\item \code{gwas_data_list}: A named list of \code{GWAS_data} objects, giving the markers score for
each possible trait/genetic model combination. The names of the list are in
the form \verb{trait (genetic model)}.
\item \code{gwas_data_thr_list}: if the input data is a \code{GWASpoly.thresh} object
(from the \code{GWASpoly::set.threshold()} function), a named list of \code{GwAS_data_thr},
with the significant markers score for each possible trait/genetic model
combination. The names of the list are in the form \verb{trait (genetic model)}.
\item \code{chrom_length}: A tibble with one row per chromosome, giving the length
(in bp) of each chromosome.
}
}
\description{
Extracts GWAS results and chromosome length from GWASpoly output.
}
