% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pot_estimator.r
\name{pot_estimator}
\alias{pot_estimator}
\title{Peaks-over-threshold (POT) Estimator}
\usage{
pot_estimator(data, u, start_xi = 0.1, start_beta = NULL, na.rm = FALSE)
}
\arguments{
\item{data}{A numeric vector of i.i.d. observations.}

\item{u}{A numeric scalar that specifies the threshold value to calculate excesses}

\item{start_xi}{Initial value of \eqn{\xi} to pass to the optimizer}

\item{start_beta}{Initial value of \eqn{\beta} to pass to the optimizer}

\item{na.rm}{Logical. If \code{TRUE}, missing values (\code{NA}) are removed
before analysis. Defaults to \code{FALSE}.}
}
\value{
An unnamed numeric vector of length 2 containing the estimated
Generalized Pareto Distribution (GPD) parameters that minimize the negative log likelihood: \eqn{\xi} (shape/tail index) and \eqn{\beta} (scale parameter).
}
\description{
This function chooses the \eqn{\hat{\xi}_{k}} and \eqn{\hat \beta} that minimize the negative log likelihood of the Generalized Pareto Distribution (GPD).
}
\details{
The PDF of a excess data point \eqn{x_i} is given by:

\deqn{f(x_i;\xi, \beta) = \frac{1}{\beta} \left(1 + \xi \frac{x_i}{\beta}\right)^{-\left(\frac{1}{\xi} + 1\right)}}

If we apply \eqn{log} to the above equation we get:

\deqn{l(x_i;\xi, \beta)=-\log(\beta) - (\frac{1}{\xi} + 1) \log(1 + \xi \frac{x_i}{\beta})}

For all excess data points \eqn{n}:

\deqn{l(\xi,\beta)=\sum_{i=1}^{n} (-\log(\beta) - (\frac{1}{\xi} + 1) \log(1 + \xi \frac{x_i}{\beta}))}

\deqn{l(\xi,\beta)=-n\log(\beta) - (\frac{1}{\xi} + 1)\sum_{i=1}^{n}  \log(1 + \xi \frac{x_i}{\beta})}

We can thus minimize \eqn{-l(\xi,\beta)}. The parameters \eqn{\xi} and \eqn{\beta} that minimize the negative log likelihood are the same that maximize the log likelihood. Hence, by using the excesses, we are able to determine \eqn{\xi} and \eqn{\beta} that best fit the tail of the data.

There is also the case to consider when \eqn{\xi = 0} which results in an exponential distribution. The total log likelihood in such a case is:

\deqn{l(0, \beta) =  -n \log(\beta) - \frac{1}{\beta} \sum_{i=1}^{n} x_i}
}
\examples{
x <- rweibull(n=800, shape = 0.8, scale = 1)
values <- pot_estimator(data = x, u = 2, start_xi = 0.1, start_beta = NULL)

}
\references{
Davison, A. C., & Smith, R. L. (1990). Models for exceedances over high thresholds. \emph{Journal of the Royal Statistical Society: Series B (Methodological)}, \bold{52}(3), 393-425. \doi{10.1111/j.2517-6161.1990.tb01796.x}

Balkema, A. A., & de Haan, L. (1974). Residual life time at great age. \emph{The Annals of Probability}, \bold{2}(5), 792-804. \doi{10.1214/aop/1176996548}

Pickands, J. (1975). Statistical Inference Using Extreme Order Statistics. \emph{The Annals of Statistics}, \bold{3}(1), 119–131. \url{http://www.jstor.org/stable/2958083}

Nair, J., Wierman, A., & Zwart, B. (2022). \emph{The Fundamentals of Heavy Tails: Properties, Emergence, and Estimation}. Cambridge University Press. (pp. 221-226) \doi{10.1017/9781009053730}
}
