% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brownian-motion-plot.R
\name{ts_brownian_motion_plot}
\alias{ts_brownian_motion_plot}
\title{Auto-Plot a Geometric/Brownian Motion Augment}
\usage{
ts_brownian_motion_plot(.data, .date_col, .value_col, .interactive = FALSE)
}
\arguments{
\item{.data}{The data you are going to pass to the function to augment.}

\item{.date_col}{The column that holds the date}

\item{.value_col}{The column that holds the value}

\item{.interactive}{The default is FALSE, TRUE will produce an interactive
plotly plot.}
}
\value{
A ggplot2 object or an interactive \code{plotly} plot
}
\description{
Plot an augmented Geometric/Brownian Motion.
}
\details{
This function will take output from either the \code{ts_brownian_motion_augment()}
or the \code{ts_geometric_brownian_motion_augment()} function and plot them. The
legend is set to "none" if the simulation count is higher than 9.
}
\examples{
library(dplyr)

df <- ts_to_tbl(AirPassengers) \%>\% select(-index)

augmented_data <- df \%>\%
  ts_brownian_motion_augment(
    .date_col = date_col,
    .value_col = value,
    .time = 144
  )

 augmented_data \%>\%
   ts_brownian_motion_plot(.date_col = date_col, .value_col = value)

}
\seealso{
Other Plot: 
\code{\link{ts_event_analysis_plot}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_random_walk_plot}()},
\code{\link{ts_scedacity_scatter_plot}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Plot}
