% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpret.R
\name{interpret}
\alias{interpret}
\title{Interpret model output}
\usage{
interpret(object)
}
\arguments{
\item{object}{alpha and assess class objects: alpha, ITS, DID, linear (ols) or logistic models.}
}
\value{
a list with interpretations of Cronbach's alpha scales or regression model results.
}
\description{
Provides simple interpretations of regression coefficients and Cronbach's
alpha from assess and alpha function classes. The interpretations describe
coefficients and significance values as well as modifying item scales.
The interpretations are text comments associated with specific parameters
of the various analyses.
}
\examples{
# Interpret Cronbach's alpha
interpret(alpha(items=c("i1","i2","i3","i4","i5"), data=cas))

# interpret a standard linear (OLS) regression
hos1 <- assess(formula=survey ~ program + month, data=hosprog, regression= "ols")
interpret(hos1)$model

# interpret a differences-in-differences model
hos2 <- assess(formula=survey ~ ., data=hosprog, intervention = "program",
int.time="month", treatment = 5, did="two", newdata=TRUE)
interpret(hos2)$did  #interpret(hos2) also runs, returns ITS results if present

# interpret an interrupted time series model
hos3 <- assess(formula=survey ~ ., data=hosprog, intervention = "program",
int.time="month", its="two", interrupt = 5)
interpret(hos3)$its
}
