% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_plt_point.R
\name{gt_plt_point}
\alias{gt_plt_point}
\title{Create a point plot in place of each value.}
\usage{
gt_plt_point(
  gt_object,
  column,
  palette = c("#007ad6", "#f0f0f0", "#f72e2e"),
  width = 25,
  scale = 1,
  accuracy = 1
)
}
\arguments{
\item{gt_object}{An existing gt table}

\item{column}{The column to transform to the percentile dot plot. Accepts \code{tidyeval}. All values must be end up being between 0 and 100.}

\item{palette}{A vector of strings of length 3. Defaults to \code{c('blue', 'lightgrey', 'red')} as hex so \code{c("#007ad6", "#f0f0f0", "#f72e2e")}}

\item{width}{A numeric, indicating the width of the plot in \code{mm}, defaults to 25}

\item{scale}{A number to multiply/scale the values in the column by. Defaults to 1, but can also be 100 if you have decimals.}

\item{accuracy}{Accuracy of the number labels in the plot, passed to \code{scales::label_number()}}
}
\value{
a gt table
}
\description{
Creates a dot/point plot in each row. Can be used as an
alternative for a bar plot. Accepts any range of values, as opposed to
\code{gt_plt_percentile} which is intended to be used for values between 0 and 100.
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{point_tab <- dplyr::tibble(x = c(seq(1.2e6, 2e6, length.out = 5))) \%>\%
  gt::gt() \%>\%
  gt_duplicate_column(x,dupe_name = "point_plot") \%>\%
  gt_plt_point(point_plot, accuracy = .1, width = 25) \%>\%
  gt::fmt_number(x, suffixing = TRUE, decimals = 1)
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{gt_plt_point.png}{options: width=500}}
}

\section{Function ID}{

3-9
}

\seealso{
Other Plotting: 
\code{\link{gt_plt_bar}()},
\code{\link{gt_plt_bar_pct}()},
\code{\link{gt_plt_bar_stack}()},
\code{\link{gt_plt_dist}()},
\code{\link{gt_plt_percentile}()},
\code{\link{gt_plt_sparkline}()},
\code{\link{gt_plt_winloss}()}
}
\concept{Plotting}
