\name{gsearlyFit}
\alias{gsearlyFit}
\title{Fit a generalized least squares model}
\usage{gsearlyFit(data, datanames = c("id","atime","catime",
      "intervention","outcome"), cmodel=FALSE, vmodel=TRUE, full=FALSE)}
\description{Fits a generalized least squares model using function \code{gls}
   (from package \code{nlme})}
\arguments{
 \item{data}{A data frame structured as  function \code{\link{simdataExtract}}.}
 \item{datanames}{Names of the five required data variables; participant,
  time-point, standardized (continuous) time-point (see
  \code{\link{tfuStandard}}), intervention arm and outcome, in that order;
  e.g. \code{c("id","atime","catime","intervention","outcome"))}.}
 \item{cmodel}{The correlation model is set to \code{FALSE}, for an
    unstructured model or to either \code{"uniform"} or \code{"exponential"},
    with default \code{FALSE}.}
 \item{vmodel}{The variance model is set to either \code{FALSE} or \code{TRUE},
    where the latter allows variances to vary by assessment occasion; default
    is \code{vmodel=TRUE}.}
 \item{full}{Either \code{FALSE}, which provides model details and parameters
  only or \code{TRUE} which provides full gls model details.}
}
\value{
 Either a gls model (\code{full=TRUE}) or a summary of the model fit
   (\code{full=FALSE}), which is a list with the components.
 \item{parameters}{Estimates of variance of beta (vbeta), beta and z
    (z=beta/sqrt(vbeta)).}
 \item{model}{A list comprised of data sample size N, number of estimated
   \code{gls} model parameters, estimated covariance (\code{vcovmat}),
  correlation (\code{corrmat}) and standard deviation (\code{sdmat}) matrices.}
}
\seealso{
 \code{\link{gsearlySimulate}}, \code{\link{simdataExtract}},
 \code{\link{modelParameters}}
}
\examples{

 # Model for full data set
 data(qol)
 mod.fulldata <- nlme::gls(QoL~(Weeks-1)+(Weeks-1):Treat, data=qol,
    correlation=nlme::corSymm(form=~1|Subject),
    weights=nlme::varIdent(form =~1|Weeks), method="ML")
 summary(mod.fulldata)

 # Use data available at day 150
 data.interim1 <- qol[qol$Day<=150,]
 mod.interim1 <- nlme::gls(QoL~(Weeks-1)+(Weeks-1):Treat, data=data.interim1,
    correlation=nlme::corSymm(form=~1|Subject),
    weights=nlme::varIdent(form=~1|Weeks), method="ML")
 summary(mod.interim1)

 # Use glsFit
 gsearlyFit(qol, datanames=c("Subject","Weeks","STime","Treat","QoL"))
 # vbeta
 vcov(mod.fulldata)[6,6]
 # beta
 coef(mod.fulldata)[6]

}
