\name{gsearly-package}
\alias{gsearly-package}
\alias{gsearly}
\docType{package}
\title{
Group sequential designs with early outcomes}
\description{
Functions to implement group sequential clinical trial designs with early
outcomes. Group sequential designs are one of the most widely used methodologies
for adaptive design in randomized clinical trials. In such designs researchers
collect data and undertake sequential analyses with the opportunity to either
reject the null hypothesis, stop the study for futility or continue recruitment
at an interim look, before reaching the planned sample size.

In situations where, for instance, outcomes are collected at long follow-up
time-points, data at interim analyses are often available for not only the study
primary (long-term) outcome time-point but also from early time-points for the
same outcome (early outcomes); e.g. a primary outcome at 12 months and early
outcomes at 3, 6 and 9 months. In settings where moderate to strong correlations
exist between the sequence of such outcomes, information can be used from the
early outcomes in addition to the final outcome at the interim analyses. The
design, planning and sample size determination for such studies is more complex
than for conventional group sequential designs and is generally achieved by
simulating individual participant data for an assumed recruitment pattern as a
means to determine information accrual during a proposed trial.

However, in practice, such simulations are complex and time-consuming to set-up
and implement and provide a barrier to the use of group sequential designs.
If we can assume approximate multivariate Normality for the distribution of the
outcomes, and also make some assumptions about the expected correlation
structure and recruitment patterns, then we can derive relatively simple
analytic expressions for information accrual during a planned trial. Allowing a
range of design options to be explored routinely without the burden of
undertaking extensive simulation studies.
}
\details{
The two main functions (i) \code{\link{gsearlyModel}} and (ii)
\code{\link{gsearlyUser}} allow designs to be constructed based on a range of
typical clinical trial recruitment patterns and correlation models.
The function \code{\link{gsearlySimulate}} simulates multivariate Normal
datasets based on a previously fitted gsearly model.
}
\references{
Parsons NR, Basu J, Stallard N. Group sequential designs for pragmatic clinical
trials with early outcomes: methods and guidance for planning and
implementation. \emph{BMC Medical Research Methodology} 2024; 24:42.
\url{https://wrap.warwick.ac.uk/id/eprint/183449/} \cr

Parsons NR, Stallard N, Parsons H, Haque A, Underwood M, Mason J, Khan I,
Costa ML, Griffin DR, Griffin J, Beard DJ, Cook JA, Davies L, Hudson J,
Metcalfe A. Group sequential designs in pragmatic trials: feasibility and
assessment of utility using data from a number of recent surgical RCTs.
\emph{BMC Medical Research Methodology} 2022; 22:256.
\url{https://wrap.warwick.ac.uk/id/eprint/169801/} \cr

}
\seealso{
\code{\link{gsearlyModel}}, \code{\link{gsearlyUser}},
\code{\link{gsearlySimulate}}
}



