% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpb.Booster.R
\name{gpb.save}
\alias{gpb.save}
\title{Save GPBoost model (booster and GPModel)}
\usage{
gpb.save(booster, filename, start_iteration = NULL, num_iteration = NULL,
  save_raw_data = FALSE, ...)
}
\arguments{
\item{booster}{Object of class \code{gpb.Booster}}

\item{filename}{saved filename}

\item{start_iteration}{int or NULL, optional (default=NULL)
Start index of the iteration to predict.
If NULL or <= 0, starts from the first iteration.}

\item{num_iteration}{int or NULL, optional (default=NULL)
Limit number of iterations in the prediction.
If NULL, if the best iteration exists and start_iteration is NULL or <= 0, the
best iteration is used; otherwise, all iterations from start_iteration are used.
If <= 0, all iterations from start_iteration are used (no limits).}

\item{save_raw_data}{If TRUE, the raw data (predictor / covariate data) for the Booster is also saved.
Enable this option if you want to change \code{start_iteration} or \code{num_iteration} at prediction time after loading.}

\item{...}{Additional named arguments passed to the \code{predict()} method of
the \code{gpb.Booster} object passed to \code{object}. 
This is only used when there is a gp_model and when save_raw_data=FALSE}
}
\value{
gpb.Booster. After loading, the GPModel can be accessed via bst_loaded$.__enclos_env__$private$gp_model
}
\description{
Save GPBoost model (booster and GPModel)
}
\examples{
\donttest{
library(gpboost)
data(GPBoost_data, package = "gpboost")

# Train model and make prediction
gp_model <- GPModel(group_data = group_data[,1], likelihood = "gaussian")
bst <- gpboost(data = X, label = y, gp_model = gp_model, nrounds = 16,
               learning_rate = 0.05, max_depth = 6, min_data_in_leaf = 5,
               verbose = 0)
pred <- predict(bst, data = X_test, group_data_pred = group_data_test[,1],
                predict_var= TRUE, pred_latent = TRUE)
# Save model to file
filename <- tempfile(fileext = ".json")
gpb.save(bst,filename = filename)
# Load from file and make predictions again
bst_loaded <- gpb.load(filename = filename)
pred_loaded <- predict(bst_loaded, data = X_test, group_data_pred = group_data_test[,1],
                       predict_var= TRUE, pred_latent = TRUE)
# Check equality
pred$fixed_effect - pred_loaded$fixed_effect
pred$random_effect_mean - pred_loaded$random_effect_mean
pred$random_effect_cov - pred_loaded$random_effect_cov
}
}
\author{
Fabio Sigrist, authors of the LightGBM R package
}
