% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{flatten_tokens}
\alias{flatten_tokens}
\title{Flatten tokens}
\usage{
flatten_tokens(tokens_list)
}
\arguments{
\item{tokens_list}{The \code{tokens} component of the API response.}
}
\value{
A flattened data frame.
}
\description{
Convert the JSON/list \code{tokens} response into a flattened data frame.
}
\examples{
\dontrun{
sample_post <- gcnlp_post(text_body = "Google, headquartered in Mountain View, unveiled
                                       the new Android phone at the Consumer Electronic Show.
                                       Sundar Pichai said in his keynote that users love
                                       their new Android phones.",
                          extract_syntax = TRUE,
                          extract_entities = TRUE,
                          extract_document_sentiment = TRUE)

flatten_tokens(tokens_list = sample_post$content$tokens)
}

}
