% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_browse.R
\name{drive_link}
\alias{drive_link}
\title{Retrieve Drive file links}
\usage{
drive_link(file)
}
\arguments{
\item{file}{Something that identifies the file(s) of interest on your Google
Drive. Can be a character vector of names/paths, a character vector of file
ids or URLs marked with \code{\link[=as_id]{as_id()}}, or a \code{\link{dribble}}.}
}
\value{
Character vector of file hyperlinks.
}
\description{
Returns the \code{"webViewLink"} for one or more files, which is the "link for
opening the file in a relevant Google editor or viewer in a browser".
}
\examples{
\dontshow{if (drive_has_token()) withAutoprint(\{ # examplesIf}
# get a few files into a dribble
three_files <- drive_find(n_max = 3)

# get their browser links
drive_link(three_files)
\dontshow{\}) # examplesIf}
}
