% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matcal.R
\name{redecompose_Omegas}
\alias{redecompose_Omegas}
\title{In the decomposition of the covariance matrices (Muirhead, 1982, Theorem A9.9), change
  the order of the covariance matrices.}
\usage{
redecompose_Omegas(M, d, W, lambdas, perm = 1:sum(M))
}
\arguments{
\item{M}{\describe{
  \item{For \strong{GMVAR} and \strong{StMVAR} models:}{a positive integer specifying the number of mixture components.}
  \item{For \strong{G-StMVAR} models:}{a size \eqn{(2\times 1)} integer vector specifying the number of \emph{GMVAR type} components \code{M1}
   in the first element and \emph{StMVAR type} components \code{M2} in the second element. The total number of mixture components
   is \code{M=M1+M2}.}
}}

\item{d}{the number of time series in the system.}

\item{W}{a length \code{d^2} vector containing the vectorized W matrix.}

\item{lambdas}{a length \code{d*(M-1)} vector of the form \strong{\eqn{\lambda_{2}}}\eqn{,...,}\strong{\eqn{\lambda_{M}}}
where \strong{\eqn{\lambda_{m}}}\eqn{=(\lambda_{m1},...,\lambda_{md})}}

\item{perm}{a vector of length \code{M} giving the new order of the covarince matrices
(relative to the current order)}
}
\value{
Returns a \eqn{d^2 + (M - 1)*d x 1} vector of the form \code{c(vec(new_W), new_lambdas)}
  where the lambdas parameters are in the regimewise order (first regime 2, then 3, etc) and the
  "new W" and "new lambdas" are constitute the new decomposition with the order of the covariance
  matrices given by the argument \code{perm}. Notice that if the first element of \code{perm}
  is one, the W matrix will be the same and the lambdas are just re-ordered.

  \strong{Note that unparametrized zero elements ARE present in the returned W!}
}
\description{
\code{redecompose_Omegas} exchanges the order of the covariance matrices in
  the decomposition of Muirhead (1982, Theorem A9.9) and returns the new decomposition.
}
\details{
We consider the following decomposition of positive definite covariannce matrices:
 \eqn{\Omega_1 = WW'}, \eqn{\Omega_m = W\Lambda_{m}W'}, \eqn{m=2,..,M} where \eqn{\Lambda_{m} = diag(\lambda_{m1},...,\lambda_{md})}
 contains the strictly postive eigenvalues of \eqn{\Omega_m\Omega_1^{-1}} and the column of the invertible \eqn{W} are the
 corresponding eigenvectors. Note that this decomposition does not necessarily exists for \eqn{M > 2}.

 See Muirhead (1982), Theorem A9.9 for more details on the decomposition and the source code for more details on the reparametrization.
}
\section{Warning}{

 No argument checks! Does not work with dimension \eqn{d=1} or with only
 one mixture component \eqn{M=1}.
}

\examples{
 d <- 2
 M <- 2
 Omega1 <- matrix(c(2, 0.5, 0.5, 2), nrow=d)
 Omega2 <- matrix(c(1, -0.2, -0.2, 1), nrow=d)

 # Decomposition with Omega1 as the first covariance matrix:
 decomp1 <- diag_Omegas(Omega1, Omega2)
 W <- matrix(decomp1[1:d^2], nrow=d, ncol=d)
 lambdas <- decomp1[(d^2 + 1):length(decomp1)]
 tcrossprod(W) # = Omega1
 W\%*\%tcrossprod(diag(lambdas), W) # = Omega2

 # Reorder the covariance matrices in the decomposition so that now
 # the first covariance matrix is Omega2:
 decomp2 <- redecompose_Omegas(M=M, d=d, W=as.vector(W), lambdas=lambdas,
                               perm=2:1)
 new_W <- matrix(decomp2[1:d^2], nrow=d, ncol=d)
 new_lambdas <- decomp2[(d^2 + 1):length(decomp2)]
 tcrossprod(new_W) # = Omega2
 new_W\%*\%tcrossprod(diag(new_lambdas), new_W) # = Omega1
}
\references{
\itemize{
  \item Muirhead R.J. 1982. Aspects of Multivariate Statistical Theory, \emph{Wiley}.
}
}
