% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-schleifer.R
\name{Schleifer}
\alias{Schleifer}
\title{Create \code{Schleifer} Object}
\usage{
Schleifer(i, to = NULL)
}
\arguments{
\item{i}{A single positive integer, which represents the position
of the \code{Schleifer} object in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the \code{Schleifer} object.}
}
\value{
A list of class \code{Schleifer}.
}
\description{
Create a \code{Schleifer} object to represent a slide ornament. See
\href{https://w3c.github.io/musicxml/musicxml-reference/elements/schleifer/}{the MusicXML specification}.
}
\examples{
# Create a `Schleifer`
schleifer <- Schleifer(1)
schleifer

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4")) + schleifer
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a \code{Schleifer} to a \code{Music} object.
}
