% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{circular_palette}
\alias{circular_palette}
\title{circular_palette}
\usage{
circular_palette(n, pal_function=rainbow, invert=FALSE, ...)
}
\arguments{
\item{n}{Number of colors to output (must be divisible by 2)}

\item{pal_function}{The base palette to circularize}

\item{invert}{Whether to invert the palette See details.}

\item{...}{Arguments passed to `pal_function`}
}
\value{
A circular color palette
}
\description{
A helper function for circularizing color palettes.
}
\details{
This function is useful when the color represents radial data. E.g. position on a sphere or circle. 
The `invert` parameter reverses the order of circularization. E.g. if your circular palette would be red to blue to red, 
`invert` changes this blue to red to blue.
}
\examples{
colors <- circular_palette(n=1000, pal_function=rainbow)
t <- seq(0,2*pi, length.out=1000)
plot(sin(t), cos(t), col = colors, pch = 19)
}
