% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmFEL_PL.R
\name{glmmFEL_pl}
\alias{glmmFEL_pl}
\title{Pseudo-likelihood engine for RSPL/MSPL (Wolfinger-style, simplified R = I)}
\usage{
glmmFEL_pl(
  y,
  X,
  Z,
  family = c("binomial_probit", "binomial_logit", "poisson_log"),
  approx = c("RSPL", "MSPL"),
  max_iter = 200L,
  tol = 1e-06,
  control = list()
)
}
\description{
This follows the vp_cp / RealVAMS structure:
\itemize{
\item Outer PQL loop updates working response (z_work) and weights (w_num).
\item Inner EM loop (with z_work, w_num fixed) updates (beta, eta, tau2).
}
}
\details{
RSPL vs MSPL:
#'  - MSPL uses \eqn{\mathrm{Var}(\eta \mid \beta, y) = (Z^\top W Z + G^{-1})^{-1}}
(called \code{H.inv} in \code{vp_cp}).
\itemize{
\item RSPL uses the eta-eta block of the inverse of the full augmented system
(called C.mat in vp_cp) for the variance-component moment update.
}
}
\keyword{internal}
