% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_data.R
\name{load_data}
\alias{load_data}
\title{Load example datasets}
\usage{
load_data(
  name = NULL,
  refresh = FALSE,
  directory = tools::R_user_dir("glmSTARMA", which = "data")
)
}
\arguments{
\item{name}{Name of the dataset to load. One of \code{"rota"}, \code{"chickenpox"}, or \code{"sst"}.}

\item{refresh}{Logical; re-download the dataset if it already exists locally.}

\item{directory}{Directory where the dataset should be cached. Defaults to a user-specific data directory of the \code{glmSTARMA} package.}
}
\value{
A named list of objects
}
\description{
Download and return datasets from the glmSTARMA GitHub repository
}
\details{
This function downloads example datasets from the glmSTARMA GitHub repository and caches them in a directory specified by the user.
The default directory is a user-specific data directory of the \code{glmSTARMA} package.
If the dataset has already been downloaded to the specified directory, it is loaded from the local cache unless \code{refresh = TRUE} is specified.
}
\examples{
\donttest{
# Load the 'chickenpox' dataset
chickenpox_data <- load_data("chickenpox", directory = tempdir())
str(chickenpox_data)
}
}
\seealso{
\code{\link{delete_glmSTARMA_data}}, \code{\link{rota}}, \code{\link{chickenpox}}, \code{\link{sst}}
}
