% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covariates.R
\name{TimeConstant}
\alias{TimeConstant}
\title{Creates a time constant covariate}
\usage{
TimeConstant(x)
}
\arguments{
\item{x}{(numeric vector) covariate values for each location. Values are used for each time-point.}
}
\value{
The input vector with an additional attribute \code{const} set to \code{"time"}.
}
\description{
This functions assigns a \code{const} attribute set to \code{"time"} to a numeric vector.
}
\details{
A time-constant covariate has the form \deqn{\mathbf{x}_t = \mathbf{x},} for some fixed vector \eqn{\mathbf{x} = (x_1, \ldots, x_p)',} i.e., it has the same value for all time-points \eqn{t}, where \eqn{x_i} is the value of the covariate at location \eqn{i}.
}
\seealso{
\link{SpatialConstant}
}
