% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_city_road.R
\docType{data}
\name{stat_cities}
\alias{stat_cities}
\alias{stat_interstates}
\alias{StatCityRoad}
\alias{StatCities}
\alias{StatInterstates}
\title{Annotate a Map with Roads and Cities}
\usage{
stat_cities(
  mapping = NULL,
  data = NULL,
  geom = ggplot2::GeomSf,
  position = "identity",
  na.rm = FALSE,
  adjust = 1,
  min_pop = 1e+05,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)

stat_interstates(
  mapping = NULL,
  data = NULL,
  geom = ggplot2::GeomSf,
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{ggplot2::aes()}}}

\item{data}{The data to be displayed in this layer}

\item{geom}{The geometric object to use display the data}

\item{position}{Position adjustment}

\item{na.rm}{if \code{TRUE}, will silently remove missing values from calculations}

\item{adjust}{A multiplicative scaling factor for the default label sizes}

\item{min_pop}{The minimum population a city must have had in 2006 to be shown.}

\item{show.legend}{Should this layer be included in the legends?}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather than
combining with them.}

\item{...}{Passed onto the underlying geoms.}
}
\value{
a \code{ggproto} object
}
\description{
Clips the \link{interstates} and \link{cities} datasets to the bounding box of the
map and plots them.
}
\examples{
library(ggplot2)
data(oregon)

ggplot(oregon, aes(group=cd_2020)) +
  geom_district() +
  stat_interstates(size=1.4, color="#0044aa55") +
  stat_cities(geom="text", min_pop=130e3, fontface="bold", adjust=0.8) +
  scale_fill_penn82() +
  theme_map()

}
\concept{geoms}
\keyword{datasets}
