% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vulkan.R
\name{ggml_vulkan_init}
\alias{ggml_vulkan_init}
\title{Initialize Vulkan backend}
\usage{
ggml_vulkan_init(device = 0L)
}
\arguments{
\item{device}{Device index (0-based, default 0)}
}
\value{
Vulkan backend pointer
}
\description{
Creates a Vulkan backend for the specified device.
The backend must be freed with ggml_vulkan_free() when done.
}
\examples{
\donttest{
if (ggml_vulkan_available() && ggml_vulkan_device_count() > 0) {
  backend <- ggml_vulkan_init(0)
  print(ggml_vulkan_backend_name(backend))
  ggml_vulkan_free(backend)
}
}
}
