% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_tracks.R
\name{feats}
\alias{feats}
\alias{feats0}
\alias{genes}
\alias{links}
\alias{seqs}
\alias{bins}
\alias{track}
\alias{pull_feats}
\alias{pull_genes}
\alias{pull_links}
\alias{pull_seqs}
\alias{pull_bins}
\alias{pull_bins.gggenomes_layout}
\alias{pull_track}
\title{Use tracks inside and outside \verb{geom_*} calls}
\usage{
feats(.track_id = 1, ..., .ignore = "genes", .geneify = FALSE)

feats0(.track_id = 1, ..., .ignore = NA, .geneify = FALSE)

genes(..., .gene_types = c("CDS", "mRNA", "tRNA", "tmRNA", "ncRNA", "rRNA"))

links(.track_id = 1, ..., .ignore = NULL, .adjacent_only = NULL)

seqs(...)

bins(..., .group = vars())

track(.track_id = 1, ..., .track_type = NULL, .ignore = NULL)

pull_feats(.x, .track_id = 1, ..., .ignore = "genes", .geneify = FALSE)

pull_genes(
  .x,
  ...,
  .gene_types = c("CDS", "mRNA", "tRNA", "tmRNA", "ncRNA", "rRNA")
)

pull_links(.x, .track_id = 1, ..., .ignore = NULL, .adjacent_only = NULL)

pull_seqs(.x, ...)

pull_bins(.x, ..., .group = vars())

\method{pull_bins}{gggenomes_layout}(.x, ..., .group = vars())

pull_track(.x, .track_id = 1, ..., .track_type = NULL, .ignore = NULL)
}
\arguments{
\item{.track_id}{The track to pull out, either as a literal variable name or
as a positive/negative integer giving the position from the left/right.}

\item{...}{Logical predicates passed on to \link[dplyr:filter]{dplyr::filter}. "seqs", "feats",
"links". Affects position-based selection.}

\item{.ignore}{track names to ignore when selecting by position.
Default is "genes", if using \code{feats0} this defaults to \code{NA}.}

\item{.geneify}{add dummy type, introns and geom_id column to play nicely
with geoms supporting multi-level and spliced gene models.}

\item{.gene_types}{return only feats of this type (\code{type \%in\% .gene_types})}

\item{.adjacent_only}{filter for links connecting direct neighbors
(\verb{abs(y-yend)==1)})}

\item{.group}{what variables to use in grouping of bins from seqs in addition
to \code{y} and \code{bin_id}. Use this to get additional shared variables from the
seqs table into the bins table.}

\item{.track_type}{restrict to these types of tracks - any combination of
"seqs", "feats", "links".}

\item{.x}{A gggenomes or gggenomes_layout object.}
}
\value{
A function that pulls the specified track from a gggenomes object.

A function that pulls the specified track from a gggenomes object.

A function that pulls the specified track from a gggenomes object.

A function that pulls the specified track from a gggenomes object.

A function that pulls the specified track from a gggenomes object.

A function that pulls the specified track from a gggenomes object.

A function that pulls the specified track from a gggenomes object.
}
\description{
Track selection works like \code{\link[dplyr:pull]{dplyr::pull()}} and supports unquoted ids and
positional arguments. \code{...} can be used to subset the data in
\code{\link[dplyr:filter]{dplyr::filter()}} fashion. \code{pull}-prefixed variants return the specified
track from a gggenomes object. Unprefixed variants work inside \verb{geom_*} calls.
}
\section{Functions}{
\itemize{
\item \code{feats()}: by default pulls out the first feat track not named
"genes".

\item \code{feats0()}: by default pulls out the first feat track.

\item \code{genes()}: pulls out the first feat track (genes), filtering
for records with \code{type=="CDS"}, and adding a dummy \code{gene_id} column if missing
to play nice with multi-exon \code{geom}s.

\item \code{links()}: by default pulls out the first link track.

\item \code{seqs()}: pulls out the seqs track (there is only one).

\item \code{bins()}: pulls out a binwise summary table of the seqs data powering
\verb{geom_bin_*()} calls. The bin table is not a real track, but recomputed
on-the-fly.

\item \code{track()}: pulls from all tracks in order seqs, feats, links.

}}
\examples{

gg <- gggenomes(emale_genes, emale_seqs, emale_tirs, emale_ava)
gg \%>\% track_info() # info about track ids, positions and types

# get first feat track that isn't "genes" (all equivalent)
gg \%>\% pull_feats() # easiest
gg \%>\% pull_feats(feats) # by id
gg \%>\% pull_feats(1) # by position
gg \%>\% pull_feats(2, .ignore = NULL) # default .ignore="genes"

# get "seqs" track (always track #1)
gg \%>\% pull_seqs()

# plot integrated transposons and GC content for some viral genomes
gg <- gggenomes(seqs = emale_seqs, feats = list(emale_ngaros, GC = emale_gc))
gg + geom_seq() +
  geom_feat(color = "skyblue") + # defaults to data=feats()
  geom_line(aes(x, y + score - .6, group = y), data = feats(GC), color = "gray60")
}
