% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/angles.R
\name{ob_angle}
\alias{ob_angle}
\alias{degree}
\alias{radian}
\alias{turn}
\title{ob_angle}
\usage{
ob_angle(
  .data = numeric(0),
  degree = numeric(0),
  radian = numeric(0),
  turn = numeric(0)
)

degree(degree = numeric(0))

radian(radian = numeric(0))

turn(turn = numeric(0))
}
\arguments{
\item{.data}{a real number indicating the number of turns.}

\item{degree}{degrees}

\item{radian}{radians}

\item{turn}{proportion of full turns of a circle (1 turn = 2 * pi radians)}
}
\value{
ob_angle
}
\description{
Creates an angle in the metric of radians, degrees, and turns.
}
\details{
Angles turns can be any real number, but degrees are displayed as values between -360 and +360, and radians are between -2pi and +2pi.
}
\section{Slots}{

\describe{
\item{\code{positive}}{if angle is negative, adds a full turn to ensure the angle is positive}

\item{\code{negative}}{if angle is positive, subtracts a full turn to ensure the angle is negative}
}}

\examples{
# Three Different ways to make a right angle
## 90 degrees
degree(90)

## half pi radians
radian(.5 * pi)

## A quarter turn
turn(.25)

# Operations
degree(30) + degree(20)
degree(350) + degree(20)
degree(30) - degree(30)
degree(30) - degree(50)

degree(30) * 2
degree(30) / 3

radian(1) + 1 # added or subtracted numbers are radians
degree(10) + 10 # added or subtracted numbers are degrees
turn(.25) + .25 # added or subtracted numbers are turns

# Trigonometric functions work as normal
sin(degree(30))
cos(degree(30))
tan(degree(30))
}
