% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scatter_ridges_function.R
\name{ggScatRidges}
\alias{ggScatRidges}
\title{Scatter Plot Combine with Ridgelines}
\usage{
ggScatRidges(
  x,
  y = NULL,
  xlab = NULL,
  ylab = NULL,
  title = NULL,
  xlim = NULL,
  ylim = NULL,
  group = NULL,
  color = "Set1",
  ridges = TRUE,
  base_size = 15,
  size = 2,
  pch = NULL,
  draw = TRUE,
  density_2d = TRUE,
  legend = TRUE,
  label = FALSE,
  legend.title = NULL,
  stats = FALSE,
  stats_method = "eu",
  anno_size = 6,
  anno_pos = "Up",
  text = NULL
)
}
\arguments{
\item{x}{As input data. If a dataframe was provided, the dataframe should contain no less than three columns. If no dataframe was supplied, a x vector should be set as an input. The vector should #' contain numerical values.}

\item{y}{As input data. If no dataframe was provided, a y vector should be set as an input along with a x vector. The vector should contain numerical values.}

\item{xlab}{To give a title for the xlab can be given here.}

\item{ylab}{To give a title for the ylab can be given here.}

\item{title}{To give a title for the plot can be given here.}

\item{xlim}{To set scale limits on the xaxis.}

\item{ylim}{To set scale limits on the yaxis.}

\item{group}{The user should provide here the grouping of the rows if a dataframe was provided, otherwise a vector.}

\item{color}{The user can choose from `display.brewer.all()`. Default = "Set1".}

\item{ridges}{The user can choose to plot, or not, the ridgelines. Default = TRUE.}

\item{base_size}{The overall size of the text in the plot. Default = 15.}

\item{size}{The size of the dots in the plot. Default = 3.}

\item{pch}{The user can change the shape of the points by providing a vector length equal to the number of groups.}

\item{draw}{If the user wants to directly draw the plot. Default = TRUE.}

\item{density_2d}{If the user wants to add density contours around group of points on the plot. Default = TRUE.}

\item{legend}{If the user wants to add or remove the legend. Default = TRUE.}

\item{label}{If the user wants to add custom labels for each point. Default = FALSE.}

\item{legend.title}{The user can provide its own title.}

\item{stats}{If the user wants to add a permanova statistical test. Default = FALSE.}

\item{stats_method}{The user can choose the method from `vegan::vegdist` to calculate pairwise distances. Default = "eu.}

\item{anno_size}{To set the font size of the statistical test results. Default = 6.}

\item{anno_pos}{To define where the statistical test results will be displayed on the graph. Default = "Up".}

\item{text}{The user can give a vector to add labels or directly provide it as a fourth column from a dataframe.}
}
\value{
A ggplot object if draw set to 'TRUE' otherwise a grob table is returned but set to invisible.
}
\description{
`ggScatRidges` is a simple function combining a scatter plot generated in 'ggplot2' to a ridgeline plot from 'ggridges' to visualise the disparities of the data points. This helps visualising the distribution of different groups in the data.
}
\examples{
# The following example is based on the iris dataset:

## Example 1
ggScatRidges(x = iris$Sepal.Length, y = iris$Sepal.Width, group = iris$Species,
             color = "Set3", ridges = TRUE, title = "plot iris", legend.title = "Grouping",
             xlab = "Sepal.Length", ylab = "Sepal.Width", base_size = 15, size = 2, 
             draw = TRUE, density_2d = TRUE, legend = TRUE, label = FALSE, text = NULL,
             stats = FALSE)

## Example 2
iris2 <- iris[,c(1,2,5)] #The 1st column will be used as 'x', the 2nd as 'y', and the 3rd as group.
ggScatRidges(x = iris2, 
             color = "Set2", ridges = TRUE, title = "plot iris",
             xlab = "Sepal.Length", ylab = "Sepal.Width", size = 2, draw = TRUE,
             density_2d = FALSE, legend = TRUE, label = FALSE, stats = TRUE) 

}
