% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geneviewer.R
\name{GC_grid}
\alias{GC_grid}
\title{Update Grid Display of a GC Chart Cluster}
\usage{
GC_grid(
  GC_chart,
  margin = NULL,
  width = NULL,
  height = NULL,
  direction = "column",
  cluster = NULL
)
}
\arguments{
\item{GC_chart}{A GC chart object.}

\item{margin}{A list specifying top, right, bottom, and left margins.}

\item{width}{Numeric or character. Width of the grid. If numeric, will be
considered as percentage.}

\item{height}{Numeric. Height of the grid.}

\item{direction}{Character. Layout direction of the grid, either "column"
(default) for vertical or "row" for horizontal.}

\item{cluster}{Numeric or character vector. Clusters in the GC chart to update.}
}
\value{
Updated GC chart with new grid display settings.
}
\description{
Modify the grid display of specified clusters within a GC chart. This
function allows users to adjust the margins, width, and height of the grid
for each cluster.
}
\examples{
genes_data <- data.frame(
  start = c(10, 90, 130, 170, 210),
  end = c(40, 120, 160, 200, 240),
  name = c('Gene 1', 'Gene 3', 'Gene 4', 'Gene 5', 'Gene 6'),
  group = c('A', 'B', 'B', 'A', 'C'),
  cluster = c(1, 1, 2, 2, 2)
)

# Set Margin of clusters
GC_chart(genes_data, cluster ="cluster", group = "group", height = "200px") \%>\%
GC_grid(margin = list(left = "50px", right = "0px"))

# Set height of a specific cluster
GC_chart(genes_data, cluster ="cluster", group = "group", height = "200px") \%>\%
GC_grid(height = "120px", cluster = 2)

}
