% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{summary,geex-method}
\alias{summary,geex-method}
\title{Object Summaries}
\usage{
\S4method{summary}{geex}(object, keep_data = TRUE, keep_args = TRUE)
}
\arguments{
\item{object}{a \code{\linkS4class{geex}} object}

\item{keep_data}{keep the original data or not}

\item{keep_args}{keep the \code{outer_args} and \code{inner_args} passed to \code{estFUN} or not}
}
\description{
Object Summaries
}
\examples{
library(geepack)
data('ohio')
glmfit  <- glm(resp ~ age, data = ohio,
              family = binomial(link = "logit"))
example_ee <- function(data, model){
  f <- grab_psiFUN(model, data)
  function(theta){
    f(theta)
  }
}
z  <- m_estimate(
estFUN = example_ee,
data = ohio,
compute_roots = FALSE,
units = 'id',
roots = coef(glmfit),
outer_args = list(model = glmfit))

object.size(z)
object.size(summary(z))
object.size(summary(z, keep_data = FALSE))
object.size(summary(z, keep_data = FALSE, keep_args = FALSE))
}
