% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gdal_helpers.R
\name{apply_geotransform}
\alias{apply_geotransform}
\title{Apply geotransform (raster column/row to geospatial x/y)}
\usage{
apply_geotransform(col_row, gt)
}
\arguments{
\item{col_row}{Numeric matrix of raster column, row (pixel/line) coordinates
(or two-column data frame that will be coerced to numeric matrix, or a
vector of column, row for one coordinate).}

\item{gt}{Either a numeric vector of length six containing the affine
geotransform for the raster, or an object of class \code{GDALRaster} from
which the geotransform will be obtained.}
}
\value{
Numeric matrix of geospatial x/y coordinates.
}
\description{
\code{apply_geotransform()} applies geotransform coefficients to raster
coordinates in pixel/line space (column/row), converting into
georeferenced (x/y) coordinates. Wrapper of \code{GDALApplyGeoTransform()} in
the GDAL API, operating on matrix input.
}
\note{
Bounds checking on the input coordinates is done if \code{gt} is obtained from an
object of class \code{GDALRaster}. See Note for \code{\link[=get_pixel_line]{get_pixel_line()}}.
}
\examples{
raster_file <- system.file("extdata/storm_lake.lcp", package="gdalraster")
ds <- new(GDALRaster, raster_file)

# compute some raster coordinates in column/row space
set.seed(42)
col_coords <- runif(10, min = 0, max = ds$getRasterXSize() - 0.00001)
row_coords <- runif(10, min = 0, max = ds$getRasterYSize() - 0.00001)
col_row <- cbind(col_coords, row_coords)

# convert to geospatial x/y coordinates
gt <- ds$getGeoTransform()
apply_geotransform(col_row, gt)

# or, using the class method
ds$apply_geotransform(col_row)

# bounds checking
col_row <- rbind(col_row, c(ds$getRasterXSize(), ds$getRasterYSize()))
ds$apply_geotransform(col_row)

ds$close()
}
\seealso{
\code{\link[=GDALRaster]{GDALRaster$getGeoTransform()}}, \code{\link[=get_pixel_line]{get_pixel_line()}}
}
