% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmplot.R
\name{lmplot}
\alias{lmplot}
\title{Plot linear model for two variables with R2 & P printed and saved}
\usage{
lmplot(
  x,
  y,
  xname = "X variable",
  yname = "Y variable",
  pngtype = c("cairo-png", "quartz", "Xlib"),
  xlab = xname,
  ylab = yname,
  plotname = xname,
  r2line = TRUE,
  pointtext = FALSE,
  pointlabs = x,
  pointcol = "black",
  savedir = "",
  ...
)
}
\arguments{
\item{x}{Explanatory variable data.}

\item{y}{Response variable data.}

\item{xname}{Variable name for plot header.}

\item{yname}{Variable name for plot header.}

\item{pngtype}{Filetype for png files, alternatively try "quartz" on Mac.}

\item{xlab}{X axis label, parsed from xname unless specified.}

\item{ylab}{Y axis label, parsed from yname unless specified.}

\item{plotname}{Filename for png, parsed from xname unless specified.}

\item{r2line}{Plot rsquared trendline, default TRUE.}

\item{pointtext}{Label each point? Default FALSE.}

\item{pointlabs}{Point labels, defaults to resvar value.}

\item{pointcol}{Points colour, default "black".}

\item{savedir}{Save location, end with "/".}

\item{...}{Allows controlling of text label params e.g. adj cex &.}
}
\value{
Invisibly saves png plot into savedir.
}
\description{
Simple function to plot and name a linear model
}
\details{
Errors and their origins:
}
\author{
Simon Dedman, \email{simondedman@gmail.com}
}
