% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fw_token.R
\name{fw_token}
\alias{fw_token}
\title{Access and loading the token key}
\usage{
fw_token(
  apikey = NULL,
  seed = NULL,
  cachefolder = NULL,
  secure = TRUE,
  inform = FALSE
)
}
\arguments{
\item{apikey}{\code{string}. The API key is automatically loaded using
the loadapikey() internal function.}

\item{seed}{\code{integer}. An integer to help track the caching of the
access token generated during data collation. If a user wants a new token,
the seed should be changed.}

\item{cachefolder}{\code{string}. The root path where the cached data will be
saved on the user's PC. If the path is not provided, the cached information
will be saved in the current working directly.}

\item{secure}{\code{logical}. If \code{TRUE}, the User will be prompted to
set the API key in the .Renviron file by running the
\code{\link{fw_setapikey}} function. The User must strictly type in API_KEY
= 'api key', save, close the file and restart the R session or RStudio for
the API_KEY environment to be captured. If \code{FALSE}, then the key will
be entered directly in the API_KEY directly in the fw_token() function.
This method is insecure, since other users can obtain the key from the codes.}

\item{inform}{\code{logical}. This is to indicate if the token has been
successfully generated. Default \code{TRUE}.}
}
\value{
\code{string} token authentication token key
}
\description{
The function updates the authentication token automatically, which the
servers generate every six hours. The function uses the API key, a one-time
key provided during registration or by database managers for already
registered users. Since the authentication token expires, the seed parameter
allows caching across user sessions. Therefore, the data downloaded with a
particular seed will be stored in memory and can be retrieved by the user. PC
rather than from servers, and hence, tremendously optimize the speed of data
access. The token is generated in two ways, depending on whether the codes
will be shared with others or for personal use. If they are for personal use,
the API key is directly pasted into the pop-up after the fw_token is
executed. However, in the latter circumstance, it is advisable to store the
API key in the R user environment and encrypt it during code execution. Check
the vignettes for handling the API key on the fwtraits GitHub.
}
\examples{

\dontrun{

#1.Use the API key in shared R examples

}

}
\seealso{
\code{\link{fw_setapikey}}
}
